﻿using LicenseSpring;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;

namespace UpdateLicenseOfflineSample
{
    static class Program
    {
        static void Main( string[] args )
        {
            try
            {
                var configuration = LSConfig.CreateManagementConfiguration();
                var service = new ManagementService( configuration );

                string licenseKey = "";

                List<License> rez = new List<License>();
                int limit = 20;
                int offset = 0;
                uint count;

                ListLicensesRequestDto dto = new ListLicensesRequestDto()
                {
                    LicenseKey = licenseKey
                };
                do
                {
                    dto.Limit = limit;
                    dto.Offset = offset;
                    var range = service.LicenseService.ListLicenses( dto, out count );
                    if( range != null ) rez.AddRange( range );
                    offset += limit;
                } while( offset < count );
                if( rez.Count == 1 )
                    PrintLicense( rez[0] );

                Console.WriteLine( "Saving license information to a file." );
                string filePath = "";//The directory where the file will be saved
                string fileName = "";//File name without extension

                service.LicenseService.SaveLicenseByKey( licenseKey, Path.Combine( filePath, fileName ) );
                PrintPause();
            }
            catch( Exception ex )
            {
                PrintException( ex );
                PrintPause();
            }
        }
        public static void PrintException( Exception ex )
        {
            if( ex is LicenseSpringException )
                Console.WriteLine( "LicenseSpring exception encountered: " + ex.Message );
            else
                Console.WriteLine( "Exception encountered: " + ex.Message );

            Exception innerException = ex.InnerException;
            while( innerException != null )
            {
                Console.WriteLine( "Inner exception: " + innerException.Message );
                innerException = innerException.InnerException;
            }
            Console.WriteLine();
        }

        public static void PrintPause()
        {
            Console.WriteLine( "\nPlease press any key to continue..." );
            Console.ReadLine();
        }

        public static void PrintLicense( ILicense license )
        {
            if( license == null )
                return;

            Console.WriteLine( "------------- License info -------------" );

            var owner = license.Owner;
            if( owner != null )
            {
                string ownerInfo = "";
                Action<string> formatInfo = dataField =>
                {
                    if( !string.IsNullOrEmpty( ownerInfo ) )
                        ownerInfo += " ";
                    if( !string.IsNullOrEmpty( dataField ) )
                        ownerInfo += dataField;
                };
                formatInfo( owner.FirstName );
                formatInfo( owner.LastName );
                formatInfo( owner.Email );
                formatInfo( owner.CompanyName );

                if( !string.IsNullOrEmpty( ownerInfo ) )
                    Console.WriteLine( "Licensed to: {0}", ownerInfo );
            }

            if( !string.IsNullOrEmpty( license.LicenseKey ) )
                Console.WriteLine( "Key = {0}", license.LicenseKey );

            if( license.LicenseUser != null )
                Console.WriteLine( "User = {0}", license.LicenseUser.Email );

            Console.WriteLine( "Type = {0}", license.LicenseType );
            Console.WriteLine( "Status = {0}", license.Status.ToString() );
            Console.WriteLine( "IsTrial = {0}", license.IsTrial );
            Console.WriteLine( "Times activated = {0}", license.TimesActivated );
            Console.WriteLine( "Max activations = {0}", license.MaxActivations );
            Console.WriteLine( "Validity Period = {0}", license.ValidityPeriodLocal() );
            Console.WriteLine( "Validity Period UTC = {0}", license.ValidityPeriod );
            Console.WriteLine( "Days remaining till license expires = {0}", license.DaysRemaining() );
            Console.WriteLine( "Maintenance period = {0}", license.MaintenancePeriodLocal() );
            Console.WriteLine( "Maintenance period UTC = {0}", license.MaintenancePeriod );
            Console.WriteLine( "Maintenance days remaining = {0}", license.MaintenanceDaysRemaining() );
            Console.WriteLine( "Is maintenance period expired = {0}", license.IsMaintenancePeriodExpired() );

            var productFeatures = license.ProductFeatures;
            if( productFeatures != null && productFeatures.Count() > 0 )
            {
                Console.WriteLine( "Product features available for this license:" );
                foreach( LicenseFeature feature in productFeatures )
                    Console.WriteLine( feature.ToString() );
            }

            var dataFields = license.CustomFields;
            if( dataFields != null && dataFields.Count() > 0 )
            {
                Console.WriteLine( "Custom data fields available for this license:" );
                foreach( CustomField field in dataFields )
                    Console.WriteLine( "Data field - Name: {0}, Value: {1}", field.Name, field.Value );
            }

            if( license.LicenseType == LicenseType.Consumption )
            {
                Console.WriteLine( "Total consumption = {0}", license.TotalConsumptions );
                Console.WriteLine( "Max consumption = {0}", license.MaxConsumptions );
                Console.WriteLine( "Is consumption overage allowed = {0}", license.AllowOverages );
                if( license.AllowOverages )
                    Console.WriteLine( "Max consumption overage = {0}", license.MaxOverages );
            }

            if( license.IsFloating )
            {
                Console.WriteLine( "This license is floating" );
                Console.WriteLine( "Timeout = {0} min", license.FloatingTimeout );
                Console.WriteLine( "Floating users = {0}", license.FloatingUsers );
            }

            Console.WriteLine();
        }

    }
}
