using UnityEditor;
using UnityEditor.SceneManagement;
using UnityEngine.SceneManagement;

namespace LicenseSpring.Editor
{
    /// <summary>
    /// Automatically opens the default scene (SampleScene) when Unity opens
    /// and no scene is currently loaded. This ensures developers always start
    /// with the correct scene after a fresh clone.
    /// </summary>
    [InitializeOnLoad]
    public static class DefaultSceneLoader
    {
        private const string DefaultScenePath = "Assets/Scenes/SampleScene.unity";

        static DefaultSceneLoader()
        {
            EditorApplication.delayCall += LoadDefaultScene;
        }

        private static void LoadDefaultScene()
        {
            if (EditorApplication.isPlayingOrWillChangePlaymode)
                return;

            Scene activeScene = SceneManager.GetActiveScene();
            if (string.IsNullOrEmpty(activeScene.path))
            {
                EditorSceneManager.OpenScene(DefaultScenePath);
            }
        }
    }
}
