using System.Collections;
using LicenseSpring;
using TMPro;
using UnityEngine;

public class ProductDetailsUI : MonoBehaviour
{
    [Header("UI References")]
    public TMP_Text productNameText;
    public TMP_Text productCodeText;
    public TMP_Text isTrialAllowedText;
    public TMP_Text trialPeriodText;
    public TMP_Text authorizationTypeText;
    

    // Start is called once before the first execution of Update after the MonoBehaviour is created
    void Start()
    {
        StartCoroutine(WaitForInitialization());
    }

    private IEnumerator WaitForInitialization()
    {
        while (LicenseSpringManager.Instance == null || !LicenseSpringManager.Instance.IsInitialized)
        {
            yield return null;
        }
        LoadProductDetails();
    }

    private void LoadProductDetails()
    {
        try
        {
            ILicenseManager licenseManager = LicenseManager.GetInstance();
            ProductDetails details = licenseManager.GetProductDetails();

            productNameText.text = details.ProductName;
            productCodeText.text = details.ProductCode;
            isTrialAllowedText.text = details.IsTrialAllowed ? "Yes" : "No";
            trialPeriodText.text = details.TrialPeriod.ToString();
            authorizationTypeText.text = details.AuthorizationType.ToString();
        }
        catch (System.Exception ex)
        {
            Debug.LogError("Failed to load product details: " + ex.Message);
        }
    }
}
