﻿using System;
using System.Diagnostics;
using System.Windows.Forms;
using LicenseSpring;

namespace AirGapSample
{
    public partial class ActivationScreen : Form
    {
        public ActivationScreen()
        {
            InitializeComponent();
            InitializeLicenseSpring();
            TryToStartInfoScreen();
        }

        private void HandleException( Exception ex )
        {
            if( ex is LicenseSpringException )
                MessageBox.Show( ex.Message, "LicenseSpring exception occurred" );
            else
                MessageBox.Show( ex.Message, "Exception occured" );
        }

        private void ShowInfoScreen()
        {
            Hide();
            var infoScreen = new InfoScreen(configuration);
            infoScreen.ShowDialog();
            Show();
        }

        private void TryToStartInfoScreen()
        {
            var licenseManager = LicenseManager.GetInstance();
            if( licenseManager == null )
                return;
            var license = licenseManager.CurrentLicense();
            if( license == null )
                return;

            try
            {
                license.LocalCheck();
            }
            catch( Exception ex )
            {
                HandleException( ex );
            }
            ShowInfoScreen();
        }

        private void InitializeLicenseSpring()
        {
            try
            {
                configuration = LSConfig.CreateConfiguration();
                var licenseManager = LicenseManager.GetInstance();
                licenseManager.Initialize( configuration );
            }
            catch( Exception ex )
            {
                HandleException( ex );
            }
        }

        private Configuration configuration = null;

        private void activationCodeButton_Click( object sender, EventArgs e )
        {
            try
            {
                var licenseManager = LicenseSpring.LicenseManager.GetInstance();
                if( keyTextBox.MaskCompleted )
                {
                    if( !string.IsNullOrEmpty( initCodeTextBox.Text ) )
                    {
                        activationCodeTextBox.Text = licenseManager.GetAirGapActivationCode( initCodeTextBox.Text, keyTextBox.Text );
                        hardwareIdTextBox.Text = configuration.HardwareID;
                    }
                    else
                    {
                        MessageBox.Show( "Type initialization code for activation" );
                        return;
                    }
                }

                else
                {
                    MessageBox.Show( "Type key for activation" );
                    return;
                }
            }
            catch( Exception ex )
            {
                HandleException( ex );
                return;
            }
        }

        private void activateAirGapButton_Click( object sender, EventArgs e )
        {
            try
            {
                var licenseManager = LicenseSpring.LicenseManager.GetInstance();
                if( !string.IsNullOrEmpty( confirmationCodeTextBox.Text ) )
                {
                    licenseManager.ActivateAirGapLicense( confirmationCodeTextBox.Text, pathTextBox.Text, keyTextBox.Text, UInt32.Parse( policyIdTextBox.Text ) );
                    var license = licenseManager.CurrentLicense();
                    if( license.IsValid() )
                        ShowInfoScreen();
                }
                else
                {
                    MessageBox.Show( "Type confirmation code for activation" );
                    return;
                }
            }
            catch( Exception ex )
            {
                HandleException( ex );
                return;
            }
        }

        private void buttonProductDetails_Click( object sender, EventArgs e )
        {
            var licenseManager = LicenseManager.GetInstance();
            var details = licenseManager.GetProductDetails();
            var infoScreen = new ProductDetailsScreen(details);
            infoScreen.ShowDialog();
        }

        private void buttonOpen_Click( object sender, EventArgs e )
        {
            OpenFileDialog fileDialog = new OpenFileDialog();
            fileDialog.DefaultExt = "lic";
            fileDialog.AddExtension = true;
            fileDialog.Filter = "License files(*.lic)|*.lic|All files(*.*)|*.*";
            var result = fileDialog.ShowDialog();
            if( DialogResult.OK == result )
            {
                pathTextBox.Text = fileDialog.FileName;
            }
        }

        private void openUrlButton_Click( object sender, EventArgs e )
        {
            try
            {
                ProcessStartInfo info = new ProcessStartInfo(@"C:\Program Files\Internet Explorer\iexplore.exe");
                info.Arguments = "https://saas.licensespring.com/air-gap";
                var licenseManager = LicenseSpring.LicenseManager.GetInstance();
                Process.Start( info );
            }
            catch( Exception ex )
            {
                HandleException( ex );
            }
        }
    }
}
