﻿using System;
using System.Windows.Forms;
using LicenseSpring;

namespace AirGapSample
{
    public partial class DeactivationScreen : Form
    {
        public DeactivationScreen( Configuration config )
        {
            InitializeComponent();
            var licenseManager = LicenseManager.GetInstance();
            var license = licenseManager.CurrentLicense();
            keyTextBox.Text = license.Key();
            configuration = config;
            activationCodeButton.Enabled = false;
            deactivateButton.Enabled = false;
        }

        private void activationCodeButton_Click( object sender, EventArgs e )
        {
            try
            {
                var licenseManager = LicenseSpring.LicenseManager.GetInstance();
                var license = licenseManager.CurrentLicense();
                if( !string.IsNullOrEmpty( initCodeTextBox.Text ) )
                {
                    activationCodeTextBox.Text = license.GetAirGapDeactivationCode( initCodeTextBox.Text );
                    hardwareIdTextBox.Text = configuration.HardwareID;
                }
                else
                {
                    MessageBox.Show( "Type initialization code for deactivation" );
                    return;
                }
            }
            catch( Exception ex )
            {
                HandleException( ex );
                return;
            }
        }

        private void deactivateButton_Click( object sender, EventArgs e )
        {
            try
            {
                var licenseManager = LicenseSpring.LicenseManager.GetInstance();
                var license = licenseManager.CurrentLicense();
                if( !string.IsNullOrEmpty( confirmationCodeTextBox.Text ) )
                {
                    license.DeactivateAirGap( confirmationCodeTextBox.Text );
                    Close();
                }
                else
                {
                    MessageBox.Show( "Type confirmation code for deactivation" );
                    return;
                }
            }
            catch( Exception ex )
            {
                HandleException( ex );
                return;
            }
        }

        private void HandleException( Exception ex )
        {
            if( ex is LicenseSpringException )
                MessageBox.Show( ex.Message, "LicenseSpring exception occurred" );
            else
                MessageBox.Show( ex.Message, "Exception occured" );
        }

        private Configuration configuration;

        private void initCodeTextBox_TextChanged( object sender, EventArgs e )
        {
            if( string.IsNullOrEmpty( initCodeTextBox.Text ) )
                 activationCodeButton.Enabled = false;
            else
                activationCodeButton.Enabled = true;
        }

        private void confirmationCodeTextBox_TextChanged( object sender, EventArgs e )
        {
             if( string.IsNullOrEmpty( confirmationCodeTextBox.Text ) )
                 deactivateButton.Enabled = false;
            else
                deactivateButton.Enabled = true;
        }
    }
}
