﻿internal static class LSConfig
{
    // Provide your LicenseSpring credentials here, please keep them safe.
    private static readonly string ApiKey = ""; // UUID
    private static readonly string SharedKey = "";
    private static readonly string ProductCode = "";

    // Use these credentials for OAuth.
    private static readonly string ClientId = "";
    private static readonly string ClientSecret = "";
    private static readonly string CryptoProviderKey = "";

    public static LicenseSpring.Configuration CreateConfiguration()
    {
        return new LicenseSpring.Configuration(
            apiKey: ApiKey,
            sharedKey: SharedKey,
            productCode: ProductCode,
            appName: System.Reflection.Assembly.GetExecutingAssembly().GetName().Name.ToString(),
            appVersion: System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString(),
            extendedOptions: CreateExtendedOptions() );
    }

    public static LicenseSpring.Configuration CreateOAuthConfiguration()
    {
        LicenseSpring.OAuthCredentials oAuthCredentials = new LicenseSpring.OAuthCredentials(ClientId, ClientSecret);
        // The SDK uses Configuration.SharedKey property as crypto key,
        // since we're not using api/shared key we need to set the CryptoProviderKey manually. 
        // If you're passing in your custom ICryptoProvider implementation,
        // you ofcourse don't need to provide a key here.
        oAuthCredentials.CryptoProviderKey = CryptoProviderKey;

        LicenseSpring.Configuration configuration = new LicenseSpring.Configuration(
            oAuthCredentials: oAuthCredentials,
            productCode: ProductCode,
            appName: System.Reflection.Assembly.GetExecutingAssembly().GetName().Name.ToString(),
            appVersion: System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString(),
            extendedOptions: CreateExtendedOptions()
            );

        return configuration;
    }

    private static LicenseSpring.ExtendedOptions CreateExtendedOptions()
    {
        var options = new LicenseSpring.ExtendedOptions();

        options.LicenseFilePath = null; // Default license file path, but you can provide your desired path
        options.HardwareID = ""; // Default HardwareID, but you can calculate device fingerprint by your own
        options.CollectNetworkInfo = true; // Send Mac, IP and Hostname to the LS platform in the requests

        // You can choose device (hardware) id calculation algorithm version or use default one
        //options.DeviceIdAlgorithm = LicenseSpring.DeviceIDAlgorithm.Gen1; // use instead of options.UseNewHardwareID = true;
        //options.DeviceIdAlgorithm = LicenseSpring.DeviceIDAlgorithm.Gen3; // short hardware id, useful for air gap licenses

        // For Web applications please set the following option
        //options.WebServiceMode = true;

        // Attention: logging is private, for developers only. It should BE DISABLED on end user computers!
        //options.EnableLogging = true;

        return options;
    }
}
