﻿Public Class LSConfig
    'Provide your LicenseSpring credentials here, please keep them safe.
    Private Shared ReadOnly ApiKey = "" 'UUID
    Private Shared ReadOnly SharedKey = ""
    Private Shared ReadOnly ProductCode = ""

    Public Shared Function CreateConfiguration() As LicenseSpring.Configuration
        Dim extOptions = CreateExtendedOptions()
        Dim config = New LicenseSpring.Configuration(
            apiKey:=ApiKey,
            sharedKey:=SharedKey,
            productCode:=ProductCode,
            appName:=System.Reflection.Assembly.GetExecutingAssembly().GetName().Name.ToString(),
            appVersion:=System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString(),
            extendedOptions:=extOptions)
        Return config
    End Function

    Private Shared Function CreateExtendedOptions() As LicenseSpring.ExtendedOptions
        Dim options = New LicenseSpring.ExtendedOptions()
        options.CollectNetworkInfo = True
        'options.DeviceIdAlgorithm = LicenseSpring.DeviceIDAlgorithm.Gen1
        'Attention: logging is private, for developers only. It should BE DISABLED on end user computers!
        'options.EnableLogging = true;
        Return options
    End Function
End Class
