﻿using System;
using LicenseSpring;

namespace Sample.LicenseSpring
{
    class KeyBasedSample : SampleBase
    {
        public override void RunOnline( ILicenseManager licenseManager, bool deactivateAndRemove = false )
        {
            var license = licenseManager.CurrentLicense();

            if( license == null )
            {
                // Assign some license key here or leave it empty to test trial key
                LicenseID licenseId = LicenseID.FromKey( "" );
                if( licenseId.IsEmpty() )
                {
                    // Provide customer information if possible
                    var userInfo = new Customer();
                    userInfo.Email = "someone@test.com";
                    userInfo.Company = "TestCompany";
                    licenseId = licenseManager.GetTrialLicense(userInfo);
                    // Or use anonymous trial license
                    //licenseId = licenseManager.GetTrialLicense( "" );
                    Console.WriteLine( "Got trial license: {0}\n", licenseId.Id() );
                }

                license = licenseManager.ActivateLicense( licenseId );
                Console.WriteLine( "License activated successfully\n" );
            }
            else
                CheckLicenseLocal( licenseManager, ref license );

            UpdateAndCheckLicense( license );

            PrintLicense( license );

            GetAndDisplayVersionsInfo( licenseManager );

            CleanUp( license, deactivateAndRemove );
        }

        public override void RunOffline( ILicenseManager licenseManager, bool deactivateAndRemove = false )
        {
            var license = licenseManager.CurrentLicense();

            if( license == null )
            {
                try
                {
                    // You can provide here path to offline activation response file,
                    // or use default desktop loaction and file name ls_activation.lic
                    license = licenseManager.ActivateLicenseOffline();
                    Console.WriteLine( "Offline activation succeeded\n" );
                }
                catch( Exception ex )
                {
                    Console.WriteLine( "Offline activation error:" );
                    PrintException( ex );

                    LicenseID licenseId = LicenseID.FromKey( "" ); // Assign some license key here
                    if( licenseId.IsEmpty() )
                    {
                        licenseId = licenseManager.GetTrialLicense( "" );
                        Console.WriteLine( "Got trial license: {0}\n", licenseId.Id() );
                    }

                    CreateOfflineActivationRequest( licenseManager, licenseId );
                    return;
                }
            }

            CheckLicenseLocal( licenseManager, ref license );

            UpdateOfflineLicense( license );

            PrintLicense( license );

            if( license.Type() == LicenseType.Consumption )
                license.UpdateConsumption();

            CleanUpLocal( licenseManager, license, deactivateAndRemove );
        }
    }
} // namespace Sample.LicenseSpring
