﻿using System;
using LicenseSpring;

namespace Sample.LicenseSpring
{
    class UserBasedSample : SampleBase
    {
        public override void RunOnline( ILicenseManager licenseManager, bool deactivateAndRemove = false )
        {
            var license = licenseManager.CurrentLicense();

            if( license == null )
            {
                // Assign user credential here or leave it empty to test trial license
                LicenseID licenseId = LicenseID.FromUser(""/*email*/, ""/*password*/ );
                if ( licenseId.IsEmpty() )
                {
                    Customer licenseUser = new Customer( "test@licensespring.com" );
                    // After next call you will get invitation email where you can set up password for new license user
                    licenseId = licenseManager.GetTrialLicense( licenseUser );
                    Console.WriteLine( "Got trial license for: {0}\n", licenseId.Id() );
                }
                // Retrieve all licenses a user with this username and password has for the current product.
                UserLicensesData[] userLicenses = licenseManager.GetUserLicenses(licenseId.User, licenseId.Password);

                // Activate the license.
                license = licenseManager.ActivateLicense( licenseId );
                Console.WriteLine( "License activated successfully\n" );
            }
            else
                CheckLicenseLocal( licenseManager, ref license );

            UpdateAndCheckLicense( license );

            PrintLicense( license );

            GetAndDisplayVersionsInfo( licenseManager );

            CleanUp( license, deactivateAndRemove );
        }

        public override void RunOffline( ILicenseManager licenseManager, bool deactivateAndRemove = false )
        {
            var license = licenseManager.CurrentLicense();

            if( license == null )
            {
                try
                {
                    // You can provide here path to offline activation response file,
                    // or use default desktop loaction and file name ls_activation.lic
                    license = licenseManager.ActivateLicenseOffline();
                    Console.WriteLine( "Offline activation succeeded\n" );
                }
                catch( Exception ex )
                {
                    Console.WriteLine( "Offline activation error:" );
                    PrintException( ex );
                    LicenseID licenseId = LicenseID.FromUser( ""/*email*/, ""/*password*/ );
                    CreateOfflineActivationRequest( licenseManager, licenseId );
                    return;
                }
            }

            CheckLicenseLocal( licenseManager, ref license );

            UpdateOfflineLicense( license );

            PrintLicense( license );

            if( license.Type() == LicenseType.Consumption )
                license.UpdateConsumption();

            CleanUpLocal( licenseManager, license, deactivateAndRemove );
        }
    }
} // namespace Sample.LicenseSpring
