﻿Imports System.Collections.Generic
Imports System.Linq
Imports LicenseSpring

Public Class KeyBasedSample
    Inherits SampleBase
    Public Overrides Sub RunOnline(ByRef licenseManager As ILicenseManager, Optional deactivateAndRemove As Boolean = False)
        Dim license = licenseManager.CurrentLicense()

        If (license Is Nothing) Then
            ' Assign some license key here or leave it empty to test trial key
            Dim license_id = LicenseID.FromKey("")
            If (license_id.IsEmpty()) Then
                license_id = licenseManager.GetTrialLicense()
                Console.WriteLine("Got trial license: {0}\n", license_id.Key)
            End If

            license = licenseManager.ActivateLicense(license_id)
            Console.WriteLine("License activated successfully\n")
        Else
            CheckLicenseLocal(license)
        End If

        UpdateAndCheckLicense(license)

        PrintLicense(license)

        GetAndDisplayVersionsInfo(licenseManager)

        license.Release()

        If (deactivateAndRemove) Then
            CleanUp(licenseManager, license)
        End If
    End Sub

    Public Overrides Sub RunOffline(ByRef licenseManager As ILicenseManager, Optional deactivateAndRemove As Boolean = False)
        Dim license = licenseManager.CurrentLicense()

        If (license Is Nothing) Then
            Try
                ' You can provide here path to offline activation response file,
                ' Or use default desktop loaction And file name ls_activation.lic
                license = licenseManager.ActivateLicenseOffline()
                Console.WriteLine("Offline activation succeeded\n")
            Catch ex As Exception
                Console.WriteLine("Offline activation error: " + ex.Message)

                Dim license_id = LicenseID.FromKey("") 'Assign some license key here
                If (license_id.IsEmpty()) Then
                    license_id = licenseManager.GetTrialLicense()
                    Console.WriteLine("Got trial license: {0}\n", license_id.Key)
                End If

                Console.WriteLine("Creating offline activation request file...")
                Dim filePath = licenseManager.GetOfflineActivationFile(license_id)
                Console.WriteLine("File created: " + filePath)
                Console.WriteLine("Please upload that request file to the LicenseSpring portal to get response file.")
                Return

            End Try
        End If

        CheckLicenseLocal(license)

        PrintLicense(license)

        If (license.Type() = LicenseType.Consumption) Then
            license.UpdateConsumption()
        End If
        If (deactivateAndRemove) Then
            CleanUpLocal(licenseManager, license)
        End If
    End Sub

End Class
