﻿Imports System
Imports LicenseSpring

Class Program
    Public Shared Sub Main(args As String())
        Dim configuration = LSConfig.CreateConfiguration()

        Console.WriteLine("------------- General info -------------")
        Console.WriteLine(configuration.AppName + " " + configuration.AppVersion)
        Console.WriteLine("LicenseSpring SDK version: " + configuration.SdkVersion)
        Console.WriteLine("LicenseSpring API version: {0}", configuration.LicenseSpringAPIVersion)
        Console.WriteLine("Determined OS version:     {0}", configuration.OSVersion)
        Console.WriteLine()

        Console.WriteLine("------------- Network info -------------")
        Console.WriteLine("Host name:   " + configuration.Hostname)
        Console.WriteLine("Local IP:    " + configuration.LocalIp)
        Console.WriteLine("MAC address: " + configuration.MACAddress)
        Console.WriteLine()

        Dim deactivateAndRemove = False ' deactivate And remove the license after sample execution
        Dim useOfflineMode = False ' test an offline mode

        Try
            Dim LicenseManager As LicenseManager = LicenseManager.GetInstance()
            LicenseManager.Initialize(configuration)

            'Get basic information about configured product
            Dim productInfo = LicenseManager.GetProductDetails()

            Console.WriteLine("------------- Product info -------------")
            Console.WriteLine("Product name:         " + productInfo.ProductName)
            Console.WriteLine("Is trial allowed:     {0}", productInfo.IsTrialAllowed)

            If (productInfo.IsTrialAllowed And productInfo.TrialPeriod > 0) Then
                Dim periodStr = "Trial period:         " + productInfo.TrialPeriod.ToString + " day"
                If (productInfo.TrialPeriod > 1) Then
                    periodStr += "s"
                End If
                Console.WriteLine(periodStr)
            End If


            Dim sample As SampleBase = Nothing
            Dim authMethod = "Authorization method: "

            If (productInfo.AuthorizationType = AuthorizationMethod.KeyBased) Then
                sample = New KeyBasedSample()
                authMethod += "Key-based"
            Else
                sample = New UserBasedSample()
                authMethod += "User-based"
            End If

            Console.WriteLine(authMethod)
            Console.WriteLine()

            ' Run appropriate sample
            If (useOfflineMode) Then
                sample.RunOffline(LicenseManager, deactivateAndRemove)
            Else
                sample.RunOnline(LicenseManager, deactivateAndRemove)
            End If

        Catch ex As LicenseSpringException
            Console.WriteLine("LicenseSpring exception encountered:")
            Console.WriteLine(ex.Message)
        Catch ex As Exception
            Console.WriteLine("Exception encountered:")
            Console.WriteLine(ex.Message)
        End Try

        Console.ReadLine()
    End Sub
End Class
