﻿using Avalonia.Controls;
using System.Text.Json;
using System.Text.Json.Serialization;
using ReactiveUI;
using System.IO;
using System.Reactive;

class ConfigData
{
    public bool EnableLogging { get; set; }
    public bool CollectNetworkInfo { get; set; }
    public string ProxyUser { get; set; }
    public string ProxyPassword { get; set; }
    public string ProxyUri { get; set; }
    public bool UseDefaultCredentials { get; set; }
}

namespace LSCrossPlatformSample
{
    class ConfigWindowViewModel : ReactiveObject
    {
        private Window _view;

        public Window view
        {
            set
            {
                _view = value;
            }
            get
            {
                return _view;
            }
        }

        private bool enableLogging;
        private bool collectNetworkInfo;
        private string proxyUser;
        private string proxyPassword;
        private string proxyUri;
        private bool useDefaultCredentials;

        public bool EnableLogging
        {
            get => enableLogging;
            set => this.RaiseAndSetIfChanged(ref enableLogging, value);
        }
        public bool CollectNetworkInfo
        {
            get => collectNetworkInfo;
            set => this.RaiseAndSetIfChanged(ref collectNetworkInfo, value);
        }
        public string ProxyUser
        {
            get => proxyUser;
            set => this.RaiseAndSetIfChanged(ref proxyUser, value);
        }
        public string ProxyPassword
        {
            get => proxyPassword;
            set => this.RaiseAndSetIfChanged(ref proxyPassword, value);
        }
        public string ProxyUri
        {
            get => proxyUri;
            set => this.RaiseAndSetIfChanged(ref proxyUri, value);
        }
        public bool UseDefaultCredentials
        {
            get => useDefaultCredentials;
            set => this.RaiseAndSetIfChanged(ref useDefaultCredentials, value);
        }

        public void onShowAsync()
        {
            view.Closing += (s, e) =>
            {
                var licenseFolderPath = System.Environment.GetFolderPath(System.Environment.SpecialFolder.LocalApplicationData);
                licenseFolderPath = Path.Combine(licenseFolderPath, "LicenseSpring");
                string fileName = Path.Combine(licenseFolderPath, "Settings.json");
                if (!File.Exists(fileName))
                    ButtonClicked();
            };
        }

        public ReactiveCommand<Unit, Unit> OkButtonClicked { get; }
        public ConfigWindowViewModel()
        {
            OkButtonClicked = ReactiveCommand.Create(ButtonClicked);
            ConfigData data;
            var licenseFolderPath = System.Environment.GetFolderPath(System.Environment.SpecialFolder.LocalApplicationData);
            licenseFolderPath = Path.Combine(licenseFolderPath, "LicenseSpring");
            string fileName = Path.Combine(licenseFolderPath, "Settings.json");
            if (File.Exists(fileName))
            {
                using (StreamReader r = new StreamReader(fileName))
                {
                    string json = r.ReadToEnd();
                    data = JsonSerializer.Deserialize<ConfigData>(json);
                    EnableLogging = data.EnableLogging;
                    CollectNetworkInfo = data.CollectNetworkInfo;
                    ProxyUser = data.ProxyUser;
                    ProxyPassword = data.ProxyPassword;
                    ProxyUri = data.ProxyUri;
                    UseDefaultCredentials = data.UseDefaultCredentials;
                }
            }
        }

        void ButtonClicked()
        {
            ConfigData data = new ConfigData();
            data.EnableLogging = EnableLogging;
            data.CollectNetworkInfo = CollectNetworkInfo;
            data.ProxyUser =ProxyUser;
            data.ProxyPassword = ProxyPassword;
            data.ProxyUri = ProxyUri;
            data.UseDefaultCredentials = UseDefaultCredentials;
            var licenseFolderPath = System.Environment.GetFolderPath(System.Environment.SpecialFolder.LocalApplicationData);
            licenseFolderPath = Path.Combine(licenseFolderPath, "LicenseSpring");
            string fileName = Path.Combine(licenseFolderPath, "Settings.json");
            using (StreamWriter sw = File.CreateText(fileName))
            {
                sw.WriteLine(JsonSerializer.Serialize(data));
            }
            view.Close();
        }
    }
}
