﻿using Avalonia.Controls;
using LicenseSpring;
using ReactiveUI;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reactive;
using System.Text;
using System.Threading.Tasks;

namespace LSCrossPlatformSample
{
    class ProductDetailsWindowViewModel : ReactiveObject
    {
        private Window _view;

        public Window view
        {
            set
            {
                _view = value;
            }
            get
            {
                return _view;
            }
        }

        private string productName;
        private string productCode;
        private bool isTrialAllowed;
        private uint trialPeriod;
        private string authorizationType;
        public string ProductName
        {
            get => productName;
            set => this.RaiseAndSetIfChanged(ref productName, value);
        }
        public string ProductCode
        {
            get => productCode;
            set => this.RaiseAndSetIfChanged(ref productCode, value);
        }
        public bool IsTrialAllowed
        {
            get => isTrialAllowed;
            set => this.RaiseAndSetIfChanged(ref isTrialAllowed, value);
        }
        public uint TrialPeriod
        {
            get => trialPeriod;
            set => this.RaiseAndSetIfChanged(ref trialPeriod, value);
        }
        public string AuthorizationType
        {
            get => authorizationType;
            set => this.RaiseAndSetIfChanged(ref authorizationType, value);
        }

        public ReactiveCommand<Unit, Unit> OkButtonClicked { get; }

        public ProductDetailsWindowViewModel(ProductDetails productInfo)
        {
            OkButtonClicked = ReactiveCommand.Create(ButtonClicked);

            ProductName = productInfo.ProductName;
            ProductCode = productInfo.ProductCode;
            IsTrialAllowed = productInfo.IsTrialAllowed;
            if (productInfo.IsTrialAllowed && productInfo.TrialPeriod > 0)
                TrialPeriod = productInfo.TrialPeriod;
            if (productInfo.AuthorizationType == AuthorizationMethod.KeyBased)
                AuthorizationType = "Key-based";
            else
                AuthorizationType = "User-based";
        }

        void ButtonClicked()
        {
            view.Close();
        }
    }
}
