﻿using Avalonia;
using Avalonia.Controls;
using Avalonia.Markup.Xaml;

namespace LSCrossPlatformSample
{
    public class ConfigWindow : Window
    {

        public ConfigWindow()
        {
            this.InitializeComponent();
#if DEBUG
            this.AttachDevTools();
#endif
        }

        private void InitializeComponent()
        {
            AvaloniaXamlLoader.Load(this);
        }

        public override void Show()
        {
            base.Show();
            ((ConfigWindowViewModel)DataContext).view = this;
            if (!set)
            {
                ((ConfigWindowViewModel)DataContext).onShowAsync();
                set = true;
            }
        }

        private bool set = false;
    }
}
