﻿using System;
using System.Diagnostics;
using System.IO;
using System.Runtime.InteropServices;
using System.Web;
using System.Windows.Forms;
using LicenseSpring;
using Microsoft.Win32;

namespace SSOSample
{

    public partial class ActivationScreen : Form
    {
        #region Dll Imports
        public static readonly uint WM_MY_MSG = RegisterWindowMessage( "WM_MY_MSG" );

        [DllImport( "user32.dll", SetLastError = true, CharSet = CharSet.Auto )]
        static extern uint RegisterWindowMessage( string lpString );
        #endregion Dll Imports

        public static readonly string Path = Application.ExecutablePath + "\\..\\common_file.txt";


        public ActivationScreen( string arg = null )
        {
            InitializeComponent();
            InitializeLicenseSpring();
            TryToStartInfoScreen( arg );
        }

        private void HandleException( Exception ex )
        {
            if( ex is LicenseSpringException )
                MessageBox.Show( ex.Message, "LicenseSpring exception occurred" );
            else
                MessageBox.Show( ex.Message, "Exception occured" );
        }

        protected override void WndProc( ref Message m )
        {
            if( m.Msg == WM_MY_MSG )
            {
                var param = File.ReadAllText( Path );
                File.Delete( Path );
                if( param.StartsWith( "licensespring://" ) )
                {
                    TryToStartInfoScreen( param );
                }
            }
            else
            {
                base.WndProc( ref m );
            }
        }

        private void ShowInfoScreen()
        {
            Hide();
            var infoScreen = new InfoScreen( configuration );
            infoScreen.ShowDialog();
            Show();
        }

        private void TryToStartInfoScreen( string arg = null )
        {
            var licenseManager = LicenseManager.GetInstance();
            if( licenseManager == null )
                return;
            try
            {
                if( !string.IsNullOrEmpty( arg ) )
                {
                    Uri myUri = new Uri( arg );
                    string code = HttpUtility.ParseQueryString( myUri.Query ).Get( "code" );
                    if( !string.IsNullOrEmpty( code ) )
                    {
                        Cursor.Current = Cursors.WaitCursor;
                        Activate();
                        licenseManager.ActivateLicense( code );
                    }
                }
                var license = licenseManager.CurrentLicense();
                if( license == null )
                    return;
                license.LocalCheck();
            }
            catch( Exception ex )
            {
                Cursor.Current = Cursors.Default;
                HandleException( ex );
            }
            Cursor.Current = Cursors.Default;
            ShowInfoScreen();
        }

        private void InitializeLicenseSpring()
        {
            try
            {
                configuration = LSConfig.CreateConfiguration();
                var licenseManager = LicenseManager.GetInstance();
                licenseManager.Initialize( configuration );
            }
            catch( Exception ex )
            {
                HandleException( ex );
            }
        }

        private Configuration configuration = null;

        private void activateSSOButton_Click( object sender, EventArgs e )
        {
            try
            {
                var licenseManager = LicenseSpring.LicenseManager.GetInstance();
                if( !string.IsNullOrEmpty( codeTextBox.Text ) || !string.IsNullOrEmpty( configuration.CustomerAccount ) )
                {
                    var ssoUrl = licenseManager.GetSSOUrl( codeTextBox.Text );
                    const string root = "HKEY_CLASSES_ROOT\\licensespring";
                    Registry.SetValue( root, "", "URL:LicenseSpring Protocol" );
                    Registry.SetValue( root, "URL Protocol", "" );
                    Registry.SetValue( root + "\\shell\\open\\command", "", "\"" + System.Reflection.Assembly.GetExecutingAssembly().Location + "\" \"%1\"" );
                    Process.Start( ssoUrl );
                }
                else
                {
                    MessageBox.Show( "Type code for activation" );
                    return;
                }
            }
            catch( Exception ex )
            {
                HandleException( ex );
                return;
            }
        }

        private void activateUserBasedButton_Click( object sender, EventArgs e )
        {
            try
            {
                var licenseManager = LicenseManager.GetInstance();
                if( userTextBox.Text.Length > 0 && passwordTextBox.Text.Length > 0 )
                    licenseManager.ActivateLicense( LicenseID.FromUser( userTextBox.Text, passwordTextBox.Text ) );
                else
                {
                    MessageBox.Show( "Type credentials for activation" );
                    return;
                }
                var license = licenseManager.CurrentLicense();
                if( license.IsValid() )
                {
                    ShowInfoScreen();
                }
            }
            catch( Exception ex )
            {
                HandleException( ex );
                return;
            }
        }
    }
}
