﻿using System;
using System.IO;
using System.Runtime.InteropServices;
using System.Threading;
using System.Windows.Forms;

namespace SSOSample
{
    static class Program
    {
        #region Dll Imports
        private const int HWND_BROADCAST = 0xFFFF;

        [DllImport( "User32.Dll", EntryPoint = "PostMessageA", SetLastError = true )]
        public static extern bool PostMessage( IntPtr hWnd, uint msg, IntPtr wParam, IntPtr lParam );

        [DllImport( "user32.dll", SetLastError = true )]
        static extern IntPtr FindWindow( string lpClassName, string lpWindowName );

        [DllImport( "user32.dll", SetLastError = true )]
        static extern IntPtr ChangeWindowMessageFilter( uint message, uint dwFlag );
        #endregion Dll Imports

        static readonly Mutex _single = new Mutex( true, "{2EA58D6F-B0F2-4E39-9FC4-A3049719DE79}" );

        [STAThread]
        static void Main( string[] args )
        {
            if( _single.WaitOne( TimeSpan.Zero, true ) )
            {
                ChangeWindowMessageFilter( ActivationScreen.WM_MY_MSG, 1 );
                Application.EnableVisualStyles();
                Application.SetCompatibleTextRenderingDefault( false );
                foreach( var s in args )
                {
                    if( s.StartsWith( "licensespring://" ) )
                    {
                        Application.Run( new ActivationScreen( s ) );
                        _single.ReleaseMutex();
                        return;
                    }
                }
                Application.Run( new ActivationScreen() );
                _single.ReleaseMutex();
            }
            else
            {
                foreach( var s in args )
                {
                    if( s.StartsWith( "licensespring://" ) )
                    {
                        File.WriteAllText( ActivationScreen.Path, s );
                        var rez = PostMessage(
                            (IntPtr)HWND_BROADCAST,
                            ActivationScreen.WM_MY_MSG,
                            IntPtr.Zero, IntPtr.Zero );
                        if( rez == false )
                        {
                            int error = Marshal.GetLastWin32Error();
                            MessageBox.Show( "The last Win32 Error was: " + error );
                        }
                        break;
                    }
                }
            }

        }
    }
}