'Please note
'To be able run this script you need to register LicenseSpring.dll in the system.
'To do that you could use regasm or another util with similar functionality.
'Register for both x64 and x32, see https://learn.microsoft.com/en-us/answers/questions/711329/dll-class-not-registered-but-appears-in-vba-object
'Open cmd with admin privileges and run:
'"C:\Windows\Microsoft.NET\Framework\v4.0.30319\RegAsm.exe" LicenseSpring.dll /tlb:LicenseSpring.tlb /codebase /nologo
'"C:\Windows\Microsoft.NET\Framework64\v4.0.30319\RegAsm.exe" LicenseSpring.dll /tlb:LicenseSpring64.tlb /codebase /nologo

'In order to test this script with MS Excel
'1) Create a blank file, open VBA Editor (Alt+F11)
'2) Add a new module and paste this script into it
'3) Then add a reference to LicenseSpring (Menu Tools->References)
'4) Run, open Immediate window to see the output (Ctrl+G)


Function LicenseSpringSample()

On Error GoTo HandleErrors

Set managerFactory = New LicenseManagerFactory
Set ConfigurationFactory = New ConfigurationFactory

Dim manager As ILicenseManager
Dim license As ILicense

'apiKey, sharedKey and productCode are required fields
'You will got an error while attempting to perform any request to the server in case fields are not valid
apiKey = ""
sharedKey = ""
ProductCode = ""

'You can set desired license file path and custom Hardware ID (and other options) through the LicenseSpringExtendedOptions
'Empty strings means use default ones, you can omit extended options at all if you don't need them
Dim extOptions As ExtendedOptions
Set extOptions = ConfigurationFactory.CreateExtendedOptionsDefault
extOptions.CollectNetworkInfo = True
extOptions.EnableLogging = True
Set Configuration = ConfigurationFactory.CreateConfiguration(apiKey, sharedKey, ProductCode, "SampleVBA", "1.2", extOptions)

Set manager = managerFactory.GetLicenseManager()
manager.Initialize (Configuration)

Set licenseFactory = New LicenseIDFactory

Set license = manager.CurrentLicense

If (license Is Nothing) Then
'Assign some license key here to test or leave it empty to test trial key
Set license_id = licenseFactory.CreateFromKey("")
If (license_id.IsEmpty()) Then
Set license_id = manager.GetTrialLicense
Debug.Print "Got trial license from the server", license_id.ID
End If

Set license = manager.ActivateLicense(license_id)
Debug.Print "License ", license_id.ID, " activated successfully"

Else

Debug.Print "License successfully loaded from file:"
Debug.Print manager.LicenseFilePath
'it's recommended to perform a localCheck (offline check) on every startup
'to be ensure that license file wasn't copied from another PC and license in a valid state
Debug.Print "Performing local check of the license..."
license.LocalCheck
Debug.Print "Local validation successful"

End If

'it's recommended to perform online check from time to time
Debug.Print "Checking license online..."
license.Check 'this call can throws errors like not enabled, expired, etc
Debug.Print "License successfully checked"

Debug.Print "------------- License info -------------"
Debug.Print "License: ", license.ID().ID
Debug.Print "Type:", license.Type
Debug.Print "Status:", license.Status
Debug.Print "IsTrial:", license.IsTrial
Debug.Print "IsOfflineActivated:", license.IsOfflineActivated
Debug.Print "Validity Period:", license.ValidityPeriod
Debug.Print "Validity Period UTC:", license.ValidityPeriodUTC
Debug.Print "Maintenance period:", license.MaintenancePeriod
Debug.Print "Maintenance period UTC:", license.MaintenancePeriodUTC
Debug.Print "Last online check date:", license.LastCheckDate
Debug.Print "Days passed since last online check:", license.DaysPassedSinceLastCheck

Dim Features As Variant
Features = license.Features
For Each LicenseFeature In Features
    Debug.Print LicenseFeature
Next

Dim deactivateAndRemove As Boolean
deactivateAndRemove = False 'set it to True to deactivate license and remove license file

If deactivateAndRemove Then

If license.IsFloating Then
license.Release_2 (True)
Debug.Print "Floating license has been revoked"
End If

If (license.Deactivate(True)) Then
Debug.Print "The license has been deactivated successfully"
End If

End If

Exit Function

HandleErrors:
btn = MsgBox("Error code: " & Err.Number & vbNewLine & "Error message: " & Err.Description, vbExclamation, "LicenseSpring Error")

End Function