﻿using LicenseSpring;
using System;
using System.Web.Mvc;
using WebApp.ViewModels;

namespace WebApp.Controllers
{
    public class HomeController : Controller
    {
        public ActionResult Index()
        {
            HomeViewModel viewModel;
            try
            {
                var licenseManager = LicenseManager.GetInstance();
                viewModel = new HomeViewModel()
                {
                    IsUserBased = licenseManager.GetProductDetails().AuthorizationType == AuthorizationMethod.UserBased
                };
            }
            catch( Exception ex )
            {
                viewModel = new HomeViewModel();
                viewModel.Exception = "Exception encountered " + ex.GetType().FullName + " : " + ex.Message + "\n";
                Exception innerEx = ex.InnerException;
                while( innerEx != null )
                {
                    viewModel.Exception += "Inner exception " + innerEx.GetType().FullName + " : " + innerEx.Message + "\n";
                    innerEx = innerEx.InnerException;
                }
            }
            return View( viewModel );
        }

        [HttpPost]
        public ActionResult GetTrial( HomeViewModel viewModel )
        {
            try
            {
                if( viewModel.IsUserBased )
                {
                    if( String.IsNullOrEmpty( viewModel.User ) )
                        viewModel.Exception = "Enter user email!";
                    else
                    {
                        var licenseManager = LicenseSpring.LicenseManager.GetInstance();
                        viewModel.Password = licenseManager.GetTrialLicense( viewModel.User ).Password;
                    }
                }
                else
                {
                    var licenseManager = LicenseSpring.LicenseManager.GetInstance();
                    viewModel.LicenseKey = licenseManager.GetTrialLicense( viewModel.User ).Key;
                }
            }
            catch( Exception ex )
            {
                viewModel.Exception = "Exception encountered " + ex.GetType().FullName + " : " + ex.Message + "\n";
                Exception innerEx = ex.InnerException;
                while( innerEx != null )
                {
                    viewModel.Exception += "Inner exception " + innerEx.GetType().FullName + " : " + innerEx.Message + "\n";
                    innerEx = innerEx.InnerException;
                }
            }
            return View( "Index", viewModel );
        }

        [HttpPost]
        public ActionResult Activate( HomeViewModel viewModel )
        {
            try
            {
                if( viewModel.IsUserBased )
                {
                    if( String.IsNullOrEmpty( viewModel.User ) || String.IsNullOrEmpty( viewModel.Password ) )
                    {
                        viewModel.Exception = "Enter user email and password!";
                        return View( "Index", viewModel );
                    }
                    else
                    {
                        var licenseManager = LicenseSpring.LicenseManager.GetInstance();
                        var license = licenseManager.CurrentLicense();
                        if( license!=null )
                            license.Deactivate();
                        license = licenseManager.ActivateLicense( LicenseID.FromUser( viewModel.User, viewModel.Password ) );
                        if( license.IsValid() )
                        {
                            LicenseViewModel licenseViewModel = new LicenseViewModel()
                            {
                                License = license
                            };
                            return View( "License", licenseViewModel );
                        }
                        viewModel.Exception = "License not valid";
                        return View( "Index", viewModel );
                    }
                }
                else
                {
                    if( String.IsNullOrEmpty( viewModel.LicenseKey ) )
                    {
                        viewModel.Exception = "Enter license key!";
                        return View( "Index", viewModel );
                    }
                    else
                    {
                        var licenseManager = LicenseSpring.LicenseManager.GetInstance();
                        var license = licenseManager.ActivateLicense( LicenseID.FromKey( viewModel.LicenseKey ) );

                        if( license.IsValid() )
                        {
                            LicenseViewModel licenseViewModel = new LicenseViewModel()
                            {
                                License = license
                            };
                            return View( "License", licenseViewModel );
                        }
                        viewModel.Exception = "License not valid";
                        return View( "Index", viewModel );
                    }
                }

            }
            catch( Exception ex )
            {
                viewModel.Exception = "Exception encountered " + ex.GetType().FullName + " : " + ex.Message + "\n";
                Exception innerEx = ex.InnerException;
                while( innerEx != null )
                {
                    viewModel.Exception += "Inner exception " + innerEx.GetType().FullName + " : " + innerEx.Message + "\n";
                    innerEx = innerEx.InnerException;
                }
                return View( "Index", viewModel );
            }
        }

        public ActionResult Info()
        {
            InfoViewModel viewModel;
            try
            {
                var licenseManager = LicenseManager.GetInstance();
                viewModel = new InfoViewModel()
                {
                    ProductDetails = licenseManager.GetProductDetails(),
                    Configuration = MvcApplication.configuration
                };
            }
            catch( Exception ex )
            {
                viewModel = new InfoViewModel();
                viewModel.Exception = "Exception encountered " + ex.GetType().FullName + " : " + ex.Message + "\n";
                Exception innerEx = ex.InnerException;
                while( innerEx != null )
                {
                    viewModel.Exception += "Inner exception " + innerEx.GetType().FullName + " : " + innerEx.Message + "\n";
                    innerEx = innerEx.InnerException;
                }
            }
            return View( viewModel );
        }

        public ActionResult License()
        {
            var licenseManager = LicenseSpring.LicenseManager.GetInstance();
            var license = licenseManager.CurrentLicense();

            LicenseViewModel licenseViewModel = new LicenseViewModel()
            {
                License = license
            };
            return View( licenseViewModel );
        }
        public ActionResult Check()
        {
            var viewModel = new LicenseViewModel();
            try
            {
                var licenseManager = LicenseSpring.LicenseManager.GetInstance();
                var license = licenseManager.CurrentLicense();

                if( license != null )
                {
                    license.LocalCheck();
                    license.Check();
                    viewModel.License = license;
                    Messagebox( "License successfully checked!" );
                }
                else
                    viewModel.Exception = "No license was activated!";
                return View( "License", viewModel );
            }
            catch( Exception ex )
            {
                viewModel.Exception = "Exception encountered " + ex.GetType().FullName + " : " + ex.Message + "\n";
                Exception innerEx = ex.InnerException;
                while( innerEx != null )
                {
                    viewModel.Exception += "Inner exception " + innerEx.GetType().FullName + " : " + innerEx.Message + "\n";
                    innerEx = innerEx.InnerException;
                }
                return View( "License", viewModel );
            }
        }
        public ActionResult Deactivate()
        {
            var viewModel = new LicenseViewModel();
            try
            {
                var licenseManager = LicenseSpring.LicenseManager.GetInstance();
                var license = licenseManager.CurrentLicense();

                if( license != null )
                {
                    license.Deactivate();
                }
                return RedirectToAction( "Index" );
            }
            catch( Exception ex )
            {
                viewModel.Exception = "Exception encountered " + ex.GetType().FullName + " : " + ex.Message + "\n";
                Exception innerEx = ex.InnerException;
                while( innerEx != null )
                {
                    viewModel.Exception += "Inner exception " + innerEx.GetType().FullName + " : " + innerEx.Message + "\n";
                    innerEx = innerEx.InnerException;
                }
                return View( "License", viewModel );
            }
        }
        public void Messagebox( string xMessage )
        {
            Response.Write( "<script>alert('" + xMessage + "')</script>" );
        }
    }
}