﻿using System;
using System.Windows.Forms;
using LicenseSpring;

namespace WinFormSample
{
    public partial class ProductDetailsScreen : Form
    {
        public ProductDetailsScreen( ProductDetails productInfo )
        {
            InitializeComponent();
            labelProductName.Text = productInfo.ProductName;
            labelProductCode.Text = productInfo.ProductCode;
            labelIsTrial.Text = productInfo.IsTrialAllowed.ToString();
            if( productInfo.IsTrialAllowed && productInfo.TrialPeriod > 0 )
                labelTrialPeriod.Text = productInfo.TrialPeriod.ToString();
            if( productInfo.AuthorizationType == AuthorizationMethod.KeyBased )
                labelAuthorizationType.Text = "Key-based";
            else
                labelAuthorizationType.Text = "User-based";
        }

        private void buttonOk_Click( object sender, EventArgs e )
        {
            Close();
        }
    }
}
