﻿using Plugin.DeviceInfo;
using Plugin.DeviceInfo.Abstractions;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.IO;
using System.Text;
using System.Text.Json;
using System.Windows.Input;
using Xamarin.Forms;
using XamarinSample.Models;

namespace XamarinSample.ViewModels
{
    class ConfigPageViewModel : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;
        private static Page page;
        public ConfigData Model { get; private set; }
        public ConfigPageViewModel()
        {
            Model = new ConfigData();
            OkButtonClicked = new Command(ButtonClicked);
            var licenseFolderPath = System.Environment.GetFolderPath(System.Environment.SpecialFolder.LocalApplicationData);
            licenseFolderPath = Path.Combine(licenseFolderPath, "LicenseSpring");
            string fileName = Path.Combine(licenseFolderPath, "Settings.json");
            if (File.Exists(fileName))
            {
                using (StreamReader r = new StreamReader(fileName))
                {
                    string json = r.ReadToEnd();
                    Model = JsonSerializer.Deserialize<ConfigData>(json);
                }
            }
        }

        public ICommand OkButtonClicked { private set; get; }

        public Page Page
        {
            set
            {
                page = value;
            }
            get
            {
                return page;
            }
        }
   
        public bool EnableLogging
        {
            get { return Model.EnableLogging; }
            set
            {
                if (Model.EnableLogging != value)
                {
                    Model.EnableLogging = value;
                    OnPropertyChanged("EnableLogging");
                }
            }
        }
        public bool CollectNetworkInfo
        {
            get { return Model.CollectNetworkInfo; }
            set
            {
                if (Model.CollectNetworkInfo != value)
                {
                    Model.CollectNetworkInfo = value;
                    OnPropertyChanged("CollectNetworkInfo");
                }
            }
        }

        public void OnShow()
        {
            Page.Disappearing += (s, e) =>
            {
                var licenseFolderPath = System.Environment.GetFolderPath(System.Environment.SpecialFolder.LocalApplicationData);
                licenseFolderPath = Path.Combine(licenseFolderPath, "LicenseSpring");
                string fileName = Path.Combine(licenseFolderPath, "Settings.json");
                if (!File.Exists(fileName))
                    ButtonClicked();
            };
        }
        void ButtonClicked()
        {
            var licenseFolderPath = System.Environment.GetFolderPath(System.Environment.SpecialFolder.LocalApplicationData);
            licenseFolderPath = Path.Combine(licenseFolderPath, "LicenseSpring");
            if (!System.IO.Directory.Exists(licenseFolderPath))
                System.IO.Directory.CreateDirectory(licenseFolderPath);
            string fileName = Path.Combine(licenseFolderPath, "Settings.json");
            using (StreamWriter sw = File.CreateText(fileName))
            {
                sw.WriteLine(JsonSerializer.Serialize(Model));
            }
            Device.BeginInvokeOnMainThread(async () => await Page.Navigation.PopAsync());
        }

        protected void OnPropertyChanged(string propName)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(propName));
        }
    }
}
