﻿using LicenseSpring;
using Plugin.DeviceInfo;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.IO;
using System.Text;
using System.Text.Json;
using System.Windows.Input;
using Xamarin.Forms;
using XamarinSample.Models;
using XamarinSample.Views;

namespace XamarinSample.ViewModels
{
    class InfoPageViewModel : INotifyPropertyChanged
    {
        private static Page page;
        public Page Page
        {
            set
            {
                page = value;
            }
            get
            {
                return page;
            }
        }
        public event PropertyChangedEventHandler PropertyChanged;
        public InfoPageModel Model { get; private set; }
        public string Key
        {
            get { return Model.Key; }
            set
            {
                if (Model.Key != value)
                {
                    Model.Key = value;
                    OnPropertyChanged("Key");
                }
            }
        }
        public string User
        {
            get { return Model.User; }
            set
            {
                if (Model.User != value)
                {
                    Model.User = value;
                    OnPropertyChanged("User");
                }
            }
        }
        public string Type
        {
            get { return Model.Type; }
            set
            {
                if (Model.Type != value)
                {
                    Model.Type = value;
                    OnPropertyChanged("Type");
                }
            }
        }
        public string Status
        {
            get { return Model.Status; }
            set
            {
                if (Model.Status != value)
                {
                    Model.Status = value;
                    OnPropertyChanged("Status");
                }
            }
        }
        public bool IsTrial
        {
            get { return Model.IsTrial; }
            set
            {
                if (Model.IsTrial != value)
                {
                    Model.IsTrial = value;
                    OnPropertyChanged("IsTrial");
                }
            }
        }
        public bool IsOfflineActivated
        {
            get { return Model.IsOfflineActivated; }
            set
            {
                if (Model.IsOfflineActivated != value)
                {
                    Model.IsOfflineActivated = value;
                    OnPropertyChanged("IsOfflineActivated");
                }
            }
        }
        public bool IsValid
        {
            get { return Model.IsValid; }
            set
            {
                if (Model.IsValid != value)
                {
                    Model.IsValid = value;
                    OnPropertyChanged("IsValid");
                }
            }
        }
        public string ValidityPeriod
        {
            get { return Model.ValidityPeriod; }
            set
            {
                if (Model.ValidityPeriod != value)
                {
                    Model.ValidityPeriod = value;
                    OnPropertyChanged("ValidityPeriod");
                }
            }
        }
        public int DaysRemaining
        {
            get { return Model.DaysRemaining; }
            set
            {
                if (Model.DaysRemaining != value)
                {
                    Model.DaysRemaining = value;
                    OnPropertyChanged("DaysRemaining");
                }
            }
        }
        public string MaintenancePeriod
        {
            get { return Model.MaintenancePeriod; }
            set
            {
                if (Model.MaintenancePeriod != value)
                {
                    Model.MaintenancePeriod = value;
                    OnPropertyChanged("MaintenancePeriod");
                }
            }
        }
        public DateTime LastChecked
        {
            get { return Model.LastChecked; }
            set
            {
                if (Model.LastChecked != value)
                {
                    Model.LastChecked = value;
                    OnPropertyChanged("LastChecked");
                }
            }
        }
        public bool IsFloating
        {
            get { return Model.IsFloating; }
            set
            {
                if (Model.IsFloating != value)
                {
                    Model.IsFloating = value;
                    OnPropertyChanged("IsFloating");
                }
            }
        }
        public uint FloatingTimeout
        {
            get { return Model.FloatingTimeout; }
            set
            {
                if (Model.FloatingTimeout != value)
                {
                    Model.FloatingTimeout = value;
                    OnPropertyChanged("FloatingTimeout");
                }
            }
        }
        public int TotalCount
        {
            get { return Model.TotalCount; }
            set
            {
                if (Model.TotalCount != value)
                {
                    Model.TotalCount = value;
                    OnPropertyChanged("TotalCount");
                }
            }
        }
        public int MaxCount
        {
            get { return Model.MaxCount; }
            set
            {
                if (Model.MaxCount != value)
                {
                    Model.MaxCount = value;
                    OnPropertyChanged("MaxCount");
                }
            }
        }
        public ICommand CheckLicense { private set; get; }
        public ICommand DeactivateLicense { private set; get; }
        public InfoPageViewModel(LicenseSpring.Configuration configuration)
        {
            Model = new InfoPageModel();
            Model.Configuration = configuration;
            updateLicenseInfo();
            CheckLicense = new Command(OnCheckLicense);
            DeactivateLicense = new Command(OnDeactivateLicense);
        }
        private void updateLicenseInfo()
        {
            try
            {
                var license = LicenseSpring.LicenseManager.GetInstance().CurrentLicense();
                Key = license.Key();
                Type = license.Type().ToString();
                Status = license.Status().ToString();
                IsTrial = license.IsTrial();
                ValidityPeriod = license.ValidityPeriod().ToString("dd/MM/yyyy");
                DaysRemaining = license.DaysRemaining();
                MaintenancePeriod = license.MaintenancePeriod().ToString("dd/MM/yyyy");
                LastChecked = license.LastCheckDate();
                TotalCount = license.TotalConsumption();
                MaxCount = license.MaxConsumption();
                User = license.User();
                IsOfflineActivated = license.IsOfflineActivated();
                IsValid = license.IsValid();
                IsFloating = license.IsFloating();
                FloatingTimeout = license.FloatingTimeout();
            }
            catch (Exception ex)
            {
                handleException(ex);
                return;
            }
        }
        public void OnShow()
        {
            Page.Disappearing += (s, e) =>
            {
                OnDeactivateLicense();
            };
        }

        void OnCheckLicense()
        {
            try
            {
                var license = LicenseSpring.LicenseManager.GetInstance().CurrentLicense();
                if (null == license)
                {
                    Device.BeginInvokeOnMainThread(async () => await Page.DisplayAlert("Error", "There is no license file!", "OK"));
                    return;
                }
                license.Check();
                Device.BeginInvokeOnMainThread(async () => await Page.DisplayAlert("Success", "License successfully checked!", "OK"));
            }
            catch (Exception ex)
            {
                handleException(ex);
            }
            updateLicenseInfo();
        }
        void OnDeactivateLicense()
        {
            try
            {
                var licenseManager = LicenseSpring.LicenseManager.GetInstance();
                var license = licenseManager.CurrentLicense();
                if (license != null) license.Deactivate();
            }
            catch (Exception ex)
            {
                handleException(ex);
            }
            Device.BeginInvokeOnMainThread(async () => await Page.Navigation.PopAsync());
        }
        protected void OnPropertyChanged(string propName)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(propName));
        }
        private void handleException(Exception ex)
        {
            if (ex is LicenseSpringException)
                Device.BeginInvokeOnMainThread(async () => await Page.DisplayAlert("Error", "LicenseSpring exception occurred\n" + ex.Message, "OK"));
            else
                Device.BeginInvokeOnMainThread(async () => await Page.DisplayAlert("Error", "Exception occured\n" + ex.Message, "OK"));
        }
        private ConfigData readConfigData()
        {
            ConfigData data;
            var licenseFolderPath = Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData);
            licenseFolderPath = Path.Combine(licenseFolderPath, "LicenseSpring");
            string fileName = Path.Combine(licenseFolderPath, "Settings.json");
            if (!File.Exists(fileName))
            {
                return null;
            }
            using (StreamReader r = new StreamReader(fileName))
            {
                string json = r.ReadToEnd();
                data = JsonSerializer.Deserialize<ConfigData>(json);
            }
            return data;
        }
    }
}
