﻿using LicenseSpring;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Windows.Input;
using Xamarin.Forms;
using XamarinSample.Models;

namespace XamarinSample.ViewModels
{
    class ProductDetailsViewModel : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;
        private static Page page;
        public ProductDetailsModel Model { get; private set; }
        public ICommand OkButtonClicked { private set; get; }
        public Page Page
        {
            set
            {
                page = value;
            }
            get
            {
                return page;
            }
        }
        public string ProductName
        {
            get { return Model.ProductName; }
            set
            {
                if (Model.ProductName != value)
                {
                    Model.ProductName = value;
                    OnPropertyChanged("ProductName");
                }
            }
        }
        public string ProductCode
        {
            get { return Model.ProductCode; }
            set
            {
                if (Model.ProductCode != value)
                {
                    Model.ProductCode = value;
                    OnPropertyChanged("ProductCode");
                }
            }
        }
        public bool IsTrialAllowed
        {
            get { return Model.IsTrialAllowed; }
            set
            {
                if (Model.IsTrialAllowed != value)
                {
                    Model.IsTrialAllowed = value;
                    OnPropertyChanged("IsTrialAllowed");
                }
            }
        }
        public uint TrialPeriod
        {
            get { return Model.TrialPeriod; }
            set
            {
                if (Model.TrialPeriod != value)
                {
                    Model.TrialPeriod = value;
                    OnPropertyChanged("TrialPeriod");
                }
            }
        }
        public string AuthorizationType
        {
            get { return Model.AuthorizationType; }
            set
            {
                if (Model.AuthorizationType != value)
                {
                    Model.AuthorizationType = value;
                    OnPropertyChanged("AuthorizationType");
                }
            }
        }
        public ProductDetailsViewModel(ProductDetails details)
        {
            Model = new ProductDetailsModel();
            OkButtonClicked = new Command(ButtonClicked);

            ProductName = details.ProductName;
            ProductCode = details.ProductCode;
            IsTrialAllowed = details.IsTrialAllowed;
            if (details.IsTrialAllowed && details.TrialPeriod > 0)
                TrialPeriod = details.TrialPeriod;
            if (details.AuthorizationType == AuthorizationMethod.KeyBased)
                AuthorizationType = "Key-based";
            else
                AuthorizationType = "User-based";
        }
        protected void OnPropertyChanged(string propName)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(propName));
        }
        void ButtonClicked()
        {
            Device.BeginInvokeOnMainThread(async () => await Page.Navigation.PopAsync());
        }
    }
}
