# PyQt6 + LicenseSpring Sample App

This is a sample Python application using **PyQt6** for the user interface and **LicenseSpring** for license management.

## 🚀 Setup

1. **Create and activate a virtual environment:**  
```bash
# Windows
python -m venv venv
source venv\Scripts\activate

# macOS/Linux
python3 -m venv venv
source venv/bin/activate
```
2. **Install dependencies:**  
```bash 
pip install -r requirements.txt
```
3. **Environment file**
In the root directory of the project, create a file named .env with the following content:

```
PRODUCT_CODE=your_product_code
API_KEY=your_api_key
SHARED_KEY=your_shared_key
```

🧾 Explanation of fields:

PRODUCT_CODE – Unique identifier of the product you're licensing.
API_KEY – Your LicenseSpring public API key.
SHARED_KEY – Shared key used for license encryption and validation.
3. **Run the application:**
```bash
python main.py
```