import os
import sys

from dotenv import load_dotenv
from PyQt6.QtWidgets import QApplication
from src import SampleApp

from licensespring.hardware import HardwareIdProviderSource
from licensespring.licensefile.config import Configuration
from licensespring.licensefile.license_manager import LicenseManager

if __name__ == "__main__":
    load_dotenv()
    PRODUCT_CODE = os.getenv("PRODUCT_CODE", None)
    API_KEY = os.getenv("API_KEY", None)
    SHARED_KEY = os.getenv("SHARED_KEY", None)
    API_URL = os.getenv("API_URL", "api.licensespring.com")

    conf = Configuration(
        product=PRODUCT_CODE,
        api_key=API_KEY,
        shared_key=SHARED_KEY,
        file_key="d66db34b03c2d6961bb3e14ff40592c0c39ec7210113f194c0da50c2d4d002be",
        file_iv="a770af52b2aa3b73ad218b6cfc4e9707",
        api_domain=API_URL,
        is_guard_file_enabled=True,
        hardware_id_provider=HardwareIdProviderSource,
    )
    license_manager = LicenseManager(conf)
    app = QApplication(sys.argv)
    window = SampleApp(license_manager)
    window.show()
    sys.exit(app.exec())
